﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading;
using System.Workflow.Runtime;
using System.Workflow.Runtime.Hosting;
using System.Workflow.Activities;








/*  WWF Local Communication Services
 
    ExternalDataExchangeService
    HandleExternalEventActivity
 
    The HandleExternalEventActivity is a blocking activity. It blocks workflow execution and
    waits until the specified event is triggered.

 */
namespace Lessons.Workflows
{
    class Program
    {
        static void Main(string[] args)
        {

            using (WorkflowRuntime workflowRuntime = new WorkflowRuntime())
            {
                AutoResetEvent waitHandle = new AutoResetEvent(false);

                workflowRuntime.WorkflowCompleted += delegate(object sender, WorkflowCompletedEventArgs e) { waitHandle.Set(); };
                workflowRuntime.WorkflowTerminated += delegate(object sender, WorkflowTerminatedEventArgs e)
                {
                    Console.WriteLine(e.Exception.Message);
                    waitHandle.Set();
                };

                /* 1. create an ExternalDataExchangeService object  
                   2. register the ExternalDataExchangeService object with the workflowRuntime  
                   3. register a WorkflowInfo service with the ExternalDataExchangeService object   */
                ExternalDataExchangeService ExchangeService = new ExternalDataExchangeService();
                workflowRuntime.AddService(ExchangeService);
                ExchangeService.AddService(new WorkflowInfo());

                WorkflowInstance instance = workflowRuntime.CreateWorkflow(typeof(Lessons.Workflows.Workflow1));
                instance.Start();

                waitHandle.WaitOne();

                Console.WriteLine("Hit <ENTER> key to exit");
                Console.ReadLine();
            }
        }
    }
}





namespace Lessons.Workflows
{
    /* an ExternalDataEventArgs descendant class used by an external event.  
       The instanceID of type Guid is used by the WWF runtime to direct the event
       to the correct workflow instance */
    [Serializable]
    public class WorkflowInfoArgs : ExternalDataEventArgs
    {
        private string text = "";

        public WorkflowInfoArgs(Guid instanceID, string Text)
            : base(instanceID)
        {
            text = Text;
        }

        public string Text { get { return text; } set { text = value; } }
    }



    /* the interface used as a contract between workflow host and workflow runtime engine 
       It now contains an event too */
    [ExternalDataExchange]
    public interface IWorkflowInfo
    {
        void InformHost(string Text);

        event EventHandler<WorkflowInfoArgs> InfoAvailable;
    }




    /* a class implementing the contract interface.
     
        Now the external method continues execution by calling an external event 
        back to the workflow. That event is handled by an HandleExternalEventActivity
        from inside the workflow
     */
    public class WorkflowInfo : IWorkflowInfo
    {
        public void InformHost(string Text)
        {
            Console.WriteLine("WorkflowInfo: " + Text);


            WorkflowInfoArgs Args = new WorkflowInfoArgs(WorkflowEnvironment.WorkflowInstanceId, Text);

            if (InfoAvailable != null)
                InfoAvailable(null, Args);
        }

        public event EventHandler<WorkflowInfoArgs> InfoAvailable;

    }

}